/*
 *  linux/arch/arm/mach-uniphier/hotplug.c
 *
 *  Copyright (C) 2012 Panasonic Corporation
 *  - Derived from arch/arm/mach-omap2/omap-hotplug.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/smp.h>

#include <asm/cacheflush.h>

#include <mach/powerdomain.h>

#include "core.h"

extern volatile int __cpuinitdata pen_release;
extern int uniphier_hotplug_cpu(unsigned int, unsigned int);

int platform_cpu_kill(unsigned int cpu)
{
	return 1;
}

/*
 * platform-specific code to shutdown a CPU
 * Called with IRQs disabled
 */
void platform_cpu_die(unsigned int cpu)
{
	unsigned int this_cpu;

	flush_cache_all();
	dsb();

	/*
	 * we're ready for shutdown now, so do it
	 */
	for (;;) {
		/*
		 * Enter into low power state
		 */
		uniphier_hotplug_cpu(cpu, PWRDM_POWER_OFF);
		this_cpu = smp_processor_id();
		if (pen_release == this_cpu) {
			/*
			 * OK, proper wakeup, we're done
			 */
			break;
		}
		pr_debug("CPU%u: spurious wakeup call\n", cpu);
	}
}

int mach_cpu_disable(unsigned int cpu)
{
	/*
	 * we don't allow CPU 0 to be shutdown (it is still too special
	 * e.g. clock tick interrupts)
	 */
	return cpu == 0 ? -EPERM : 0;
}
